function Supprimer-Element {
    param (
        [string]$cheminElement
    )

    if (Test-Path $cheminElement) {
        if (Test-Path -PathType Container $cheminElement) {
            Remove-Item -Recurse -Force $cheminElement
            Write-Host "Dossier supprim"
        } else {
            Remove-Item -Force $cheminElement
            Write-Host "Fichier supprim"
        }
    } else {
        Write-Host "lment introuvable : $cheminElement"
    }
}

function Copier-Element {
    param (
        [string]$source,
        [string]$destination
    )

    if (Test-Path $source) {
        Copy-Item -Recurse -Force $source $destination
        Write-Host "Copie reussie"
    } else {
        Write-Host "Element introuvable pour la copie : $source"
    }
}


$cheminRacineJeu = "C:\Program Files (x86)\Steam\steamapps\common\Lethal Company"
if (-not (Test-Path $cheminRacineJeu -PathType Container)) {
    $cheminRacineJeu = Read-Host "Entrez le chemin de votre jeu (ex: 'D:\Jeux\Steam\steamapps\common\Lethal Company') "
}

if (-not (Test-Path $cheminRacineJeu -PathType Container)) {
    Write-Host "Le dossier Lethal Comany n'a pas t trouv"
    Pause
    Exit
}

if (Test-Path $cheminRacineJeu -PathType Container) {
    $filesName = @('BepInEx', 'BoomboxController', 'doorstop_config.ini', 'winhttp.dll', 'version.txt')

    $dossierCourant = Get-Location

    foreach ($element in $filesName) {
        $cheminSource = Join-Path $dossierCourant $element
        $cheminDestination = Join-Path $cheminRacineJeu $element

        Supprimer-Element -cheminElement $cheminDestination

        Copier-Element -source $cheminSource -destination $cheminDestination
    }

    Write-Host "Modpack install avec succs !"
} else {
    Write-Host "Resayer ou installer le modpack a la main."
}

Pause